var samplePageObj = {
  // 샘플 타이틀
  title: '피벗',
  subtitle: '시트에 조회된 데이터를 이용하여 피벗팅된 데이터를 생성/확인합니다.',

  // 샘플 설명
  desc: 'drag & drop 으로 시트 헤더를 피벗 생성 기준영역으로 이동시켜, 피벗 데이터를 가공하여 표시할 수 있습니다. ',

  // 객체 초기화 구문
  init: {
    Def: {
      Col: {
        Align: 'Left',
        RelWidth: '1'
      },
    },
    Cfg: {
      CanSort: '0',
      // UsePivot:1,
      // AcceptPivotRows:"sDept,sTeam,sPosition,sName,sGender,sAgeRange,sAddr,sAge,sPeriod",
      // AcceptPivotCols:"sDept,sTeam,sPosition,sName,sGender,sAgeRange,sAddr,sAge,sPeriod",
      // AcceptPivotData:"sAge,sPeriod,sSalary,sBonus",
      // PivotFormat:"#,### 원"
    },
    Cols: [
      {
        Header: '부서명',
        Type: 'Text',
        Name: 'sDept'
      },
      {
        Header: '팀명',
        Type: 'Text',
        Name: 'sTeam'
      },
      {
        Header: '직급',
        Type: 'Text',
        Name: 'sPosition'
      },
      {
        Header: '성명',
        Type: 'Text',
        Name: 'sName'
      },
      {
        Header: '성별',
        Type: 'Enum',
        Name: 'sGender',
        Align: 'Center',
        Enum: '|男|女|기타',
        EnumKeys: '|男|女|기타'
      },
      {
        Header: '연령대',
        Type: 'Enum',
        Name: 'sAgeRange',
        Align: 'Center',
        Enum: '|10대|20대|30대|40대|50대|60대',
        EnumKeys: '|10대|20대|30대|40대|50대|60대'
      },
      {
        Header: '거주지',
        Type: 'Text',
        Name: 'sAddr',
        Align: 'Center'
      },
      {
        Header: '나이',
        Type: 'Int',
        Name: 'sAge',
        Width: '130',
        Align: 'Right',
      },
      {
        Header: '근속기간(년)',
        Type: 'Int',
        Name: 'sPeriod',
        Align: 'Right'
      },
      {
        Header: '급여',
        Type: 'Int',
        Name: 'sSalary',
        Align: 'Right',
        Format: '#,###'
      },
      {
        Header: '상여',
        Type: 'Int',
        Name: 'sBonus',
        Align: 'Right',
        Format: '#,###'
      },

    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><button type=\'button\' onclick=\'sampleBtn()\'>피벗 다이얼로그</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
    sheet.createPivotDialog();
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      sDept: 'CEO',
      sTeam: '임원',
      sPosition: '대표이사',
      sName: '황정열',
      sGender: '男',
      sAgeRange: '50대',
      sAddr: '서울',
      sAge: 50,
      sPeriod: 15,
      sSalary: 10122200,
      sBonus: 1012220
    },
    {
      sDept: 'SI사업부',
      sTeam: '임원',
      sPosition: '상무',
      sName: '강대호',
      sGender: '男',
      sAgeRange: '40대',
      sAddr: '경기',
      sAge: 47,
      sPeriod: 15,
      sSalary: 6756170,
      sBonus: 675617
    },
    {
      sDept: 'SI사업부',
      sTeam: '개발1팀',
      sPosition: '부장',
      sName: '김미경',
      sGender: '女',
      sAgeRange: '30대',
      sAddr: '강원',
      sAge: 39,
      sPeriod: 12,
      sSalary: 4180950,
      sBonus: 418095
    },
    {
      sDept: 'SI사업부',
      sTeam: '개발1팀',
      sPosition: '과장',
      sName: '김선희',
      sGender: '女',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 34,
      sPeriod: 7,
      sSalary: 3217000,
      sBonus: 321700
    },
    {
      sDept: 'SI사업부',
      sTeam: '개발1팀',
      sPosition: '과장',
      sName: '최세희',
      sGender: '女',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 32,
      sPeriod: 3,
      sSalary: 2750800,
      sBonus: 275080
    },
    {
      sDept: 'SI사업부',
      sTeam: '개발1팀',
      sPosition: '대리',
      sName: '이명희',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 29,
      sPeriod: 3,
      sSalary: 2571900,
      sBonus: 257190
    },
    {
      sDept: 'SI사업부',
      sTeam: '개발1팀',
      sPosition: '사원',
      sName: '노효일',
      sGender: '男',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 23,
      sPeriod: 1,
      sSalary: 1520150,
      sBonus: 152020
    },
    {
      sDept: 'SI사업부',
      sTeam: '개발1팀',
      sPosition: '사원',
      sName: '원영국',
      sGender: '男',
      sAgeRange: '20대',
      sAddr: '경기',
      sAge: 28,
      sPeriod: 2,
      sSalary: 2557000,
      sBonus: 255700
    },
    {
      sDept: 'SI사업부',
      sTeam: '개발1팀',
      sPosition: '사원',
      sName: '이지선',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 24,
      sPeriod: 2,
      sSalary: 2007500,
      sBonus: 200750
    },
    {
      sDept: '인사부',
      sTeam: '인사1팀',
      sPosition: '부장',
      sName: '김상도',
      sGender: '男',
      sAgeRange: '40대',
      sAddr: '경기',
      sAge: 40,
      sPeriod: 9,
      sSalary: 4290850,
      sBonus: 429085
    },
    {
      sDept: '인사부',
      sTeam: '인사1팀',
      sPosition: '대리',
      sName: '한보라',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 28,
      sPeriod: 5,
      sSalary: 1959500,
      sBonus: 195950
    },
    {
      sDept: '인사부',
      sTeam: '인사2팀',
      sPosition: '사원',
      sName: '장태우',
      sGender: '男',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 28,
      sPeriod: 1,
      sSalary: 1959500,
      sBonus: 195950
    },
    {
      sDept: '인사부',
      sTeam: '인사2팀',
      sPosition: '차장',
      sName: '정필석',
      sGender: '男',
      sAgeRange: '40대',
      sAddr: '경기',
      sAge: 40,
      sPeriod: 4,
      sSalary: 3851150,
      sBonus: 385120
    },
    {
      sDept: '솔루션사업부',
      sTeam: '임원',
      sPosition: '이사',
      sName: '조성목',
      sGender: '男',
      sAgeRange: '40대',
      sAddr: '경기',
      sAge: 41,
      sPeriod: 15,
      sSalary: 6313700,
      sBonus: 631370
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '부장',
      sName: '유봉근',
      sGender: '男',
      sAgeRange: '40대',
      sAddr: '서울',
      sAge: 42,
      sPeriod: 5,
      sSalary: 5187610,
      sBonus: 518760
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '차장',
      sName: '오필환',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 37,
      sPeriod: 4,
      sSalary: 3412510,
      sBonus: 341250
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '차장',
      sName: '송복석',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 39,
      sPeriod: 6,
      sSalary: 3871680,
      sBonus: 387170
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '과장',
      sName: '김남연',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 36,
      sPeriod: 4,
      sSalary: 3500700,
      sBonus: 350070
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '대리',
      sName: '한혜선',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 29,
      sPeriod: 2,
      sSalary: 2746000,
      sBonus: 274600
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '사원',
      sName: '조미미',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 25,
      sPeriod: 2,
      sSalary: 2297040,
      sBonus: 229700
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '사원',
      sName: '고은혜',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 26,
      sPeriod: 1,
      sSalary: 2390740,
      sBonus: 239070
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '사원',
      sName: '성열',
      sGender: '男',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 27,
      sPeriod: 1,
      sSalary: 2409000,
      sBonus: 240900
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발1팀',
      sPosition: '사원',
      sName: '김영중',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '인천',
      sAge: 28,
      sPeriod: 3,
      sSalary: 2871100,
      sBonus: 287110
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPosition: '부장',
      sName: '김명호',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 38,
      sPeriod: 8,
      sSalary: 3709800,
      sBonus: 370980
    },
    {
      sDept: '솔루션사업부',
      sTeam: '개발2팀',
      sPosition: '사원',
      sName: '하태선',
      sGender: '男',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 28,
      sPeriod: 1,
      sSalary: 2415010,
      sBonus: 241500
    },
    {
      sDept: '솔루션사업부',
      sTeam: '영업팀',
      sPosition: '사원',
      sName: '김정민',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 32,
      sPeriod: 3,
      sSalary: 2989010,
      sBonus: 298900
    },
    {
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPosition: '차장',
      sName: '장성훈',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 37,
      sPeriod: 5,
      sSalary: 3880150,
      sBonus: 388020
    },
    {
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPosition: '차장',
      sName: '강윤식',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 35,
      sPeriod: 7,
      sSalary: 3855600,
      sBonus: 385560
    },
    {
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPosition: '대리',
      sName: '김수연',
      sGender: '女',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 30,
      sPeriod: 1,
      sSalary: 2698800,
      sBonus: 269880
    },
    {
      sDept: '솔루션사업부',
      sTeam: '기술지원팀',
      sPosition: '대리',
      sName: '정은지',
      sGender: '女',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 30,
      sPeriod: 1,
      sSalary: 2698800,
      sBonus: 269880
    },
    {
      sDept: '영업팀',
      sTeam: '영업1팀',
      sPosition: '사원',
      sName: '정창호',
      sGender: '男',
      sAgeRange: '20대',
      sAddr: '서울',
      sAge: 27,
      sPeriod: 1,
      sSalary: 1897500,
      sBonus: 189750
    },
    {
      sDept: '영업팀',
      sTeam: '영업2팀',
      sPosition: '대리',
      sName: '김대현',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 33,
      sPeriod: 5,
      sSalary: 2709800,
      sBonus: 270980
    },
    {
      sDept: '기술연구소',
      sTeam: '연구1팀',
      sPosition: '소장',
      sName: '안남주',
      sGender: '女',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 38,
      sPeriod: 10,
      sSalary: 4891350,
      sBonus: 489140
    },
    {
      sDept: '기술연구소',
      sTeam: '연구1팀',
      sPosition: '차장',
      sName: '이민수',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 38,
      sPeriod: 8,
      sSalary: 3845010,
      sBonus: 384500
    },
    {
      sDept: '기술연구소',
      sTeam: '연구1팀',
      sPosition: '차장',
      sName: '최갑석',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 38,
      sPeriod: 5,
      sSalary: 3500700,
      sBonus: 350070
    },
    {
      sDept: '기술연구소',
      sTeam: '연구1팀',
      sPosition: '차장',
      sName: '김태헌',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 37,
      sPeriod: 6,
      sSalary: 3489000,
      sBonus: 348900
    },
    {
      sDept: '기술연구소',
      sTeam: '연구1팀',
      sPosition: '과장',
      sName: '박정석',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '서울',
      sAge: 32,
      sPeriod: 3,
      sSalary: 2885000,
      sBonus: 288500
    },
    {
      sDept: '기술연구소',
      sTeam: '연구1팀',
      sPosition: '과장',
      sName: '권기윤',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 37,
      sPeriod: 7,
      sSalary: 3450100,
      sBonus: 345010
    },
    {
      sDept: '경영지원팀',
      sTeam: '경영1팀',
      sPosition: '차장',
      sName: '김승운',
      sGender: '男',
      sAgeRange: '30대',
      sAddr: '경기',
      sAge: 39,
      sPeriod: 2,
      sSalary: 3505700,
      sBonus: 350570
    },
    {
      sDept: '경영지원팀',
      sTeam: '경영1팀',
      sPosition: '사원',
      sName: '이해영',
      sGender: '女',
      sAgeRange: '20대',
      sAddr: '경기',
      sAge: 23,
      sPeriod: 1,
      sSalary: 1800800,
      sBonus: 180080
    }
  ]

};
var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
